import { Navigate } from "react-router-dom";
import { useAuth } from "./AuthContext";

export default function RoleRoute({ roles, children }) {
  const { user } = useAuth();

  if (!user) {
    return <Navigate to="/login" replace />;
  }

  if (!roles.includes(user.role)) {
    return (
      <div style={{ padding: 20, fontSize: 14 }}>
        Kamu tidak memiliki akses ke halaman ini.
      </div>
    );
  }

  return children;
}