import axios from "axios";
import toast from "react-hot-toast";
import { getToken, logoutUser } from "../authService";

const api = axios.create({
  baseURL: "http://127.0.0.1:8000/api",
  withCredentials: false,
});

// ====== REQUEST INTERCEPTOR (kirim token setiap request) ======
api.interceptors.request.use(
  (config) => {
    const token = getToken();

    if (token) {
      config.headers.Authorization = `Bearer ${token}`;
    }

    return config;
  },
  (error) => Promise.reject(error)
);

// ====== RESPONSE INTERCEPTOR (auto logout kalau 401) ======
api.interceptors.response.use(
  (response) => response,
  (error) => {
    if (error.response && error.response.status === 401) {
      // Tampilkan toast
      toast.error("Sesi kamu telah berakhir. Silakan login kembali.");

      // Hapus token & user
      logoutUser();

      // Delay 500ms biar toast tampil dulu sebelum redirect
      setTimeout(() => {
        window.location.href = "/login";
      }, 2000);
    }

    return Promise.reject(error);
  }
);

export default api;