export default function SignatureBlock({
  label,
  date,
  signature,
  name,
  title
}) {
  return (
    <div className="sig-col">
      <div className="sig-label">{label}</div>

      <div className="sig-date">
        {date ? date : "\u00A0"}
      </div>

      <div className="sig-box">
        {signature ? (
          <img src={signature} alt="signature" className="sig-image" />
        ) : (
          <div className="sig-empty">&nbsp;</div>
        )}
      </div>

      <div className="sig-name">{name || "-"}</div>
      <div className="sig-title"><strong>{title}</strong></div>
    </div>
  );
}