import React from "react";
import { Toaster } from "react-hot-toast";
import ReactDOM from "react-dom/client";
import { BrowserRouter, Routes, Route } from "react-router-dom";

import { AuthProvider } from "./AuthContext";

import LoginPage from "./pages/LoginPage";
import SignupPage from "./pages/SignupPage";
import ForgotPasswordPage from "./pages/ForgotPasswordPage";
import ResetPasswordPage from "./pages/ResetPasswordPage";

import TrainingListPage from "./pages/TrainingListPage";
import TrainingFormPage from "./pages/TrainingFormPage";
import TrainingDetailPage from "./pages/TrainingDetailPage";
import TrainingEditPage from "./pages/TrainingEditPage";

import PrivateRoute from "./PrivateRoute";
import RoleRoute from "./RoleRoute";

import "./index.css";

ReactDOM.createRoot(document.getElementById("root")).render(
  <React.StrictMode>
    <BrowserRouter>
      <AuthProvider>
        <Toaster position="top-center" />
        <Routes>

          {/* PUBLIC ROUTE */}
          <Route path="/login" element={<LoginPage />} />
          <Route path="/signup" element={<SignupPage />} />
          <Route path="/forgot-password" element={<ForgotPasswordPage />} />
          <Route path="/reset-password" element={<ResetPasswordPage />} />

          {/* PROTECTED ROUTE */}
          <Route
            path="/"
            element={
              <PrivateRoute>
                <TrainingListPage />
              </PrivateRoute>
            }
          />

          <Route
            path="/training/new"
            element={
              <PrivateRoute>
                <RoleRoute roles={["user"]}>
                  <TrainingFormPage />
                </RoleRoute>
              </PrivateRoute>
            }
          />

          <Route
            path="/training/:id"
            element={
              <PrivateRoute>
                <TrainingDetailPage />
              </PrivateRoute>
            }
          />

          <Route
            path="/training/edit/:id"
            element={
              <PrivateRoute>
                <RoleRoute roles={["user"]}>
                  <TrainingEditPage />
                </RoleRoute>
              </PrivateRoute>
            }
          />

        </Routes>
      </AuthProvider>
    </BrowserRouter>
  </React.StrictMode>
);