import { useState } from "react";
import { Link } from "react-router-dom";
import api from "../api/api";

export default function ForgotPasswordPage() {
  const [email, setEmail] = useState("");
  const [loading, setLoading] = useState(false);
  const [message, setMessage] = useState("");
  const [error, setError] = useState("");

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    setError("");
    setMessage("");

    try {
      const res = await api.post("/forgot-password", { email });
      setMessage(
        res.data.reset_url
          ? "Link reset (dev): " + res.data.reset_url
          : res.data.message
      );
    } catch (err) {
      console.error(err);
      setError(
        err.response?.data?.message ||
          "Gagal mengirim permintaan reset password."
      );
    } finally {
      setLoading(false);
    }
  };

  return (
    <div className="login-page">
      <div className="login-card">
        <h1>Lupa Password</h1>
        <p>
          Masukkan email yang kamu gunakan untuk login. Untuk saat ini (mode
          dev), link reset akan ditampilkan di layar.
        </p>

        <form onSubmit={handleSubmit}>
          <div className="login-field">
            <label>Email</label>
            <input
              type="email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              required
            />
          </div>

          {error && (
            <div style={{ color: "#fca5a5", fontSize: 12, marginBottom: 8 }}>
              {error}
            </div>
          )}

          {message && (
            <div
              style={{
                color: "#bbf7d0",
                fontSize: 12,
                marginBottom: 8,
                wordBreak: "break-all",
              }}
            >
              {message}
            </div>
          )}

          <button
            type="submit"
            className="btn btn-primary"
            style={{ width: "100%", justifyContent: "center" }}
            disabled={loading}
          >
            {loading ? "Mengirim..." : "Kirim Link Reset"}
          </button>
        </form>

        <p style={{ marginTop: 12, fontSize: 12 }}>
          <Link to="/">Kembali ke login</Link>
        </p>
      </div>
    </div>
  );
}