import { useState } from "react";
import { useNavigate , Link} from "react-router-dom";
import { useAuth } from "../AuthContext";

export default function LoginPage() {
  const { login } = useAuth();
  const navigate = useNavigate();
  const [email, setEmail] = useState();
  const [password, setPassword] = useState();
  const [error, setError] = useState("");

  const handleSubmit = async (e) => {
    e.preventDefault();
    setError("");
    try {
      await login(email, password);
      navigate("/");
    } catch (err) {
      setError(
        err.response?.data?.message || "Login gagal. Cek email/password."
      );
    }
  };

  return (
    <div className="login-page">
        <div className="login-card">
        <h1>Login Training Portal</h1>
        <p>Masuk untuk mengajukan dan menyetujui permohonan training.</p>

        <form onSubmit={handleSubmit}>
            <div className="login-field">
            <label>Email</label>
            <input
                type="email"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
            />
            </div>

            <div className="login-field">
            <label>Password</label>
            <input
                type="password"
                value={password}
                onChange={(e) => setPassword(e.target.value)}
            />
            </div>

            {error && (
            <div style={{ color: "#fca5a5", fontSize: 12, marginBottom: 8 }}>
                {error}
            </div>
            )}

            <button type="submit" className="btn btn-primary" style={{ width: "100%", justifyContent: "center" }}>
            Login
            </button>
            <p style={{ marginTop: 10, fontSize: 12}}>
                <Link to="/forgot-password">Lupa password?</Link>
            </p>
            <p style={{ marginTop: 4, fontSize: 12 }}>
            Belum punya akun? <Link to="/signup">Daftar di sini</Link>
            </p>
        </form>

        
        </div>
    </div>
  );
}