import { useState } from "react";
import { useNavigate, useSearchParams, Link } from "react-router-dom";
import api from "../api/api";

export default function ResetPasswordPage() {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();
  const initialEmail = searchParams.get("email") || "";
  const token = searchParams.get("token") || "";

  const [email, setEmail] = useState(initialEmail);
  const [password, setPassword] = useState("");
  const [passwordConfirm, setPasswordConfirm] = useState("");
  const [loading, setLoading] = useState(false);
  const [message, setMessage] = useState("");
  const [error, setError] = useState("");

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    setError("");
    setMessage("");

    try {
      const res = await api.post("/reset-password", {
        token,
        email,
        password,
        password_confirmation: passwordConfirm,
      });

      setMessage(res.data.message || "Password berhasil direset.");

      setTimeout(() => {
        navigate("/");
      }, 1500);
    } catch (err) {
      console.error(err);
      setError(
        err.response?.data?.message ||
          "Gagal reset password. Link mungkin sudah kadaluarsa."
      );
    } finally {
      setLoading(false);
    }
  };

  if (!token) {
    return (
      <div className="login-page">
        <div className="login-card">
          <h1>Reset Password</h1>
          <p>Token tidak ditemukan. Coba minta ulang link reset.</p>
          <p style={{ marginTop: 12, fontSize: 12 }}>
            <Link to="/forgot-password">Kembali ke lupa password</Link>
          </p>
        </div>
      </div>
    );
  }

  return (
    <div className="login-page">
      <div className="login-card">
        <h1>Reset Password</h1>
        <p>Masukkan password baru untuk akun ini.</p>

        <form onSubmit={handleSubmit}>
          <div className="login-field">
            <label>Email</label>
            <input
              type="email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              required
            />
          </div>

          <div className="login-field">
            <label>Password Baru</label>
            <input
              type="password"
              value={password}
              onChange={(e) => setPassword(e.target.value)}
              required
            />
          </div>

          <div className="login-field">
            <label>Konfirmasi Password Baru</label>
            <input
              type="password"
              value={passwordConfirm}
              onChange={(e) => setPasswordConfirm(e.target.value)}
              required
            />
          </div>

          {error && (
            <div style={{ color: "#fca5a5", fontSize: 12, marginBottom: 8 }}>
              {error}
            </div>
          )}

          {message && (
            <div style={{ color: "#bbf7d0", fontSize: 12, marginBottom: 8 }}>
              {message}
            </div>
          )}

          <button
            type="submit"
            className="btn btn-primary"
            style={{ width: "100%", justifyContent: "center" }}
            disabled={loading}
          >
            {loading ? "Menyimpan..." : "Reset Password"}
          </button>
        </form>

        <p style={{ marginTop: 12, fontSize: 12 }}>
          <Link to="/">Kembali ke login</Link>
        </p>
      </div>
    </div>
  );
}