// src/pages/TrainingDetailPage.jsx
import { useEffect, useState } from "react";
import { useNavigate, useParams } from "react-router-dom";
import api from "../api/api";
import { useAuth } from "../AuthContext";
import logoCikos from "../assets/logo-cikos.png";
import { formatDateWithDay, formatTanggalIndonesia } from "../utils/date";
import signHrd from "../assets/sign-hrd.png";
import signDirector from "../assets/sign-director.png";
import SignatureBlock from "../components/SignatureBlock";

export default function TrainingDetailPage() {
  const { id } = useParams();
  const navigate = useNavigate();
  const { user } = useAuth();
  const [data, setData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [hrdNotes, setHrdNotes] = useState("");
  const isHrd = user?.role === "hrd";

 {/*const loadData = async () => {
    setLoading(true);
    const res = await api.get(`/training-requests/${id}`);
    setData(res.data);
    setLoading(false);
  };*/}

  const loadData = async () => {
  setLoading(true);
  const res = await api.get(`/training-requests/${id}`);
  setData(res.data);
  setHrdNotes(res.data.hrd_notes || ""); // ← supaya textarea kepakai nilai awal
  setLoading(false);
};

  useEffect(() => {
    loadData();
  }, [id]);

 const handleApproveHrd = async () => {
  try {
    await api.post(`/training-requests/${id}/approve-hrd`, {
      hrd_notes: hrdNotes,
    });
    await loadData();
    alert("Berhasil disetujui HRD");
  } catch (err) {
    console.error(err);
    alert("Gagal menyetujui HRD");
  }
};

const handleRejectHrd = async () => {
  try {
    await api.post(`/training-requests/${id}/reject-hrd`, {
      hrd_notes: hrdNotes,
    });
    await loadData();
    alert("Berhasil ditolak HRD");
  } catch (err) {
    console.error(err);
    alert("Gagal menolak HRD");
  }
};

  const handlePrint = () => {
    window.print();
  };

  if (loading) return <div style={{ padding: 20 }}>Loading...</div>;
  if (!data) return <div style={{ padding: 20 }}>Data tidak ditemukan.</div>;

  const purposes = data.purposes || [];
  
  const createdAt = formatDateWithDay(data.created_at);
  const trainingDate = formatDateWithDay(data.training_date);

  const pemohon = data.user || {};
  const hrdApprover = data.hrd_approver || null;
const directorApprover = data.director_approver || null;

const hrdDisplayName = hrdApprover?.name || "HRGA";
const directorDisplayName = directorApprover?.name || "Direktur";

  // helper tampilan status
  const statusLabel = (() => {
    switch (data.status) {
      case "submitted":
        return "Diajukan (menunggu persetujuan HRD)";
      case "approved_hrd":
        return "Disetujui HRD (menunggu Persetujuan Direktur)";
      case "rejected_hrd":
        return "Ditolak HRD";
      case "approved_director":
        return "Disetujui HRD & Direktur";
      case "rejected_director":
        return "Disetujui HRD, ditolak Direktur";
      default:
        return data.status;
    }
  })();

  const formatRupiah = (v) =>
    typeof v === "number"
      ? v.toLocaleString("id-ID", { style: "currency", currency: "IDR" })
      : "-";

 
  return (
    <div className="print-page">
      {/* Tombol yang hanya muncul di layar, disembunyikan saat print */}
      <div className="no-print" style={{ margin: "10px 0px 20px 0px" }}>
        <button onClick={() => navigate(-1)} style={{ marginRight: 10 }}>
          &larr; Kembali
        </button>
        <button onClick={handlePrint}>Print</button>
        <span style={{ marginLeft: 20 , fontSize: 15}}>
          Login as: <strong>{user?.name}</strong> ({user?.role})
        </span>
      </div>

      {/* Header dokumen */}
      <header className="doc-header">
        <div className="doc-header-left">
          <img src={logoCikos} alt="Logo PT Cikos Indonesia" />
        </div>
        <div className="doc-header-center">
          <h2>PT. CIKOS INDONESIA</h2>
          <h3>FORM PERMOHONAN / PENGAJUAN TRAINING</h3>
        </div>
        <div className="doc-header-right">
          <table>
            <tbody>
              <tr>
                <td>No. Dokumen</td>
                <td>:</td>
                <td>FR-HRGA-032</td>
              </tr>
              <tr>
                <td>Tgl Dibuat</td>
                <td>:</td>
                <td>13/06/2024</td>
              </tr>
              <tr>
                <td>Revisi</td>
                <td>:</td>
                <td>0</td>
              </tr>
              <tr>
                <td>Hal</td>
                <td>:</td>
                <td>1 dari 1</td>
              </tr>
            </tbody>
          </table>
        </div>
      </header>

      {/* Info status */}
      <div className="doc-status">
        <strong>Status:</strong> {statusLabel}
      </div>

      {/* Identitas pemohon */}
      <section className="doc-section">
        <h4>DATA PEMOHON</h4>
        <table className="doc-table">
          <tbody>
            <tr>
              <td style={{ width: "20%" }}>Nama</td>
              <td style={{ width: "3%" }}>:</td>
              <td>{pemohon.name || "-"}</td>
            </tr>
            <tr>
              <td>Tanggal Pengajuan</td>
              <td>:</td>
              <td>{createdAt}</td>
            </tr>
            <tr>
              <td>Jabatan</td>
              <td>:</td>
              <td>{pemohon.position || "-"}</td>
            </tr>
            <tr>
              <td>Departemen</td>
              <td>:</td>
              <td>{pemohon.department || "-"}</td>
            </tr>
          </tbody>
        </table>
      </section>

      {/* Data Training */}
      <section className="doc-section">
        <h4>DATA TRAINING</h4>
        <table className="doc-table">
          <tbody>
            <tr>
              <td style={{ width: "20%" }}>No. Pengajuan</td>
              <td style={{ width: "3%" }}>:</td>
              <td>{data.request_code}</td>
            </tr>
            <tr>
              <td style={{ width: "20%" }}>Nama Training</td>
              <td style={{ width: "3%" }}>:</td>
              <td>{data.title}</td>
            </tr>
            <tr>
              <td>Waktu</td>
              <td>:</td>
              <td>{trainingDate}</td>
            </tr>
            <tr>
              <td>Penyelenggara</td>
              <td>:</td>
              <td>{data.vendor || "-"}</td>
            </tr>
            <tr>
              <td>Biaya</td>
              <td>:</td>
              <td>{formatRupiah(data.cost)}</td>
            </tr>
          </tbody>
        </table>
      </section>

      {/* Tujuan Training */}
      <section className="doc-section">
        <h4>TUJUAN TRAINING</h4>
        <div className="doc-checkbox-group">
          <CheckboxLine
            label="Meningkatkan keterampilan"
            checked={purposes.includes("skill")}
          />
          <CheckboxLine
            label="Meningkatkan pengetahuan manajerial"
            checked={purposes.includes("managerial")}
          />
          <CheckboxLine
            label="Memenuhi kriteria Job Description"
            checked={purposes.includes("jobdesc")}
          />
          <CheckboxLine
            label="Penyegaran / Refreshment"
            checked={purposes.includes("refreshment")}
          />
          {/* Kalau nanti kamu mau 'lain-lain', tinggal tambah item lagi */}
        </div>
      </section>

      {/* Hasil yang diharapkan */}
      <section className="doc-section">
        <h4>
          Hasil yang bisa Peserta perlihatkan/sumbangkan pada Perusahaan
          (dalam bentuk nyata)
        </h4>
        <div className="doc-textbox">
          {data.expected_result || "-"}
        </div>
      </section>

      {/* Saran HRD */}
     {/*<section className="doc-section">
        <h4>SARAN HRD</h4>
        <div className="doc-textbox">
          {data.hrd_notes || "-"}
        </div>
      </section>*/}
       {/* CATATAN / SARAN HRD */}
       {/* SARAN / CATATAN HRD */}
      <section className="doc-section">
    <h4>SARAN HRD</h4>

    {/* Tampilan untuk print & untuk user/direktur (readonly) */}
    <div className="doc-textbox">
        {data.hrd_notes || "-"}
    </div>

    {/* Area input + tombol hanya untuk HRD, hanya saat status submitted, dan hanya di layar */}
    {isHrd && data.status === "submitted" && (
        <div className="no-print" style={{ marginTop: 8 }}>
        <textarea
            rows={3}
            placeholder="Tulis catatan / saran HRD di sini..."
            value={hrdNotes}
            onChange={(e) => setHrdNotes(e.target.value)}
            style={{
            width: "100%",
            marginTop: 4,
            padding: 8,
            borderRadius: 8,
            border: "1px solid #4b5563",
            background: "#020617",
            color: "#e5e7eb",
            fontSize: 13,
            }}
        />
        <div style={{ display: "flex", gap: 8, marginTop: 8 }}>
            <button
            type="btn btn-xs"
            onClick={handleApproveHrd}
            style={{
                padding: "6px 12px",
                borderRadius: 8,
                border: "none",
                background: "#16a34a",
                color: "white",
                fontSize: 12,
                cursor: "pointer",
            }}
            >
            Approve
            </button>
            <button
            type="button"
            onClick={handleRejectHrd}
            style={{
                padding: "6px 12px",
                borderRadius: 8,
                border: "none",
                background: "#dc2626",
                color: "white",
                fontSize: 12,
                cursor: "pointer",
            }}
            >
            Reject
            </button>
        </div>
        </div>
    )}
      </section>

      {/* Tanda tangan */}
     
  <section className="doc-section doc-signatures">
  {/* Kolom 1: Pemohon */}
  <div className="sig-col">
    <div className="sig-label">Diajukan oleh,</div>
    <div className="sig-date">
    
    </div>

    <div className="sig-box">
       <div className="sig-approved">
        <img className="sig-image" />
       </div>
       
    </div>
    
    <div>{pemohon.name || "Karyawan"}</div>
    <div className="sig-name">
      <div>{pemohon.position || "Karyawan"}</div>
    </div>
  </div>

  {/* Kolom 2: HRGA */}
  <div className="sig-col">
    <div className="sig-label">Disetujui oleh,</div>
    <div className="sig-date">
      {data.approved_at_hrd
        ? formatTanggalIndonesia(data.approved_at_hrd)
        : "\u00A0"}
    </div>
   

    <div className="sig-box">
      {data.approved_by_hrd && data.status !== "rejected_hrd" ? (
        <div className="sig-approved">
          <img
            src={signHrd}
            alt="Tanda tangan HRGA"
            className="sig-image"
          />
        </div>
      ) : (
        <span className="sig-await"></span>
      )}
    </div>
 <div>{hrdDisplayName}</div>
    <div className="sig-name">
      <strong>HRGA</strong>
    </div>
    
  </div>

  {/* Kolom 3: Direktur */}
  <div className="sig-col">
    <div className="sig-label">Diketahui oleh,</div>
    <div className="sig-date">
      {data.approved_at_director
        ? formatTanggalIndonesia(data.approved_at_director)
        : "\u00A0"}
    </div>

    <div className="sig-box">
      {data.approved_by_director && data.status === "approved_director" ? (
        <div className="sig-approved">
          <img
            src={signDirector}
            alt="Tanda tangan Direktur"
            className="sig-image"
          />
        </div>
      ) : (
        <span className="sig-await"></span>
      )}
    </div>
<div>{directorDisplayName}</div>
    <div className="sig-name">
      <strong>Direktur</strong>
    </div>
    
    
  </div>
  </section>
</div>
  );
}

function CheckboxLine({ label, checked }) {
  return (
    <div className="doc-checkbox-line">
      <div className="doc-checkbox">{checked ? "☑" : "☐"}</div>
      <span>{label}</span>
    </div>
  );
}