<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('training_requests', function (Blueprint $table) {
        $table->id();
        $table->foreignId('user_id')->constrained()->onDelete('cascade');

        // Data pengajuan
        $table->string('title');                   // Nama training
        $table->text('description')->nullable();   // Deskripsi tambahan
        $table->date('training_date');             // Waktu
        $table->string('vendor')->nullable();      // Penyelenggara
        $table->unsignedBigInteger('cost')->nullable(); // Biaya (diisi user)

        // Tujuan training (bisa multi option)
        $table->json('purposes')->nullable();      // ["skill","managerial",...]
        $table->text('expected_result')->nullable(); // Hasil yang diharapkan

        // Status & catatan
        $table->enum('status', [
            'submitted',           // baru diajukan user
            'approved_hrd',        // sudah disetujui HRD
            'rejected_hrd',        // ditolak HRD
            'approved_director',   // disetujui Direktur (hanya >20jt)
            'rejected_director',   // ditolak Direktur (hanya >20jt)
        ])->default('submitted');

        $table->text('hrd_notes')->nullable();     // saran HRD

        // Tracking approval
        $table->foreignId('approved_by_hrd')->nullable()
              ->constrained('users');
        $table->timestamp('approved_at_hrd')->nullable();

        $table->foreignId('approved_by_director')->nullable()
              ->constrained('users');
        $table->timestamp('approved_at_director')->nullable();

        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('training_requests');
    }
};
