<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('training_requests', function (Blueprint $table) {
            $table->string('request_code', 30)
                  ->unique()
                  ->after('id')
                  ->nullable(); // kita isi via script setelah create
        });
    }

    public function down(): void
    {
        Schema::table('training_requests', function (Blueprint $table) {
            $table->dropColumn('request_code');
        });
    }
};
