<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\TrainingRequestController;
use Illuminate\Support\Facades\Route;

Route::post('/login', [AuthController::class, 'login']);
    //buat akun
Route::post('/register', [AuthController::class, 'register']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/me', [AuthController::class, 'me']);
    Route::post('/logout', [AuthController::class, 'logout']);



    // Export
    Route::get('/training-requests/export', [TrainingRequestController::class, 'export']);

    // Training Requests CRUD
    Route::get('/training-requests', [TrainingRequestController::class, 'index']);
    Route::post('/training-requests', [TrainingRequestController::class, 'store']);
    Route::get('/training-requests/{trainingRequest}', [TrainingRequestController::class, 'show']);
    Route::put('/training-requests/{trainingRequest}', [TrainingRequestController::class, 'update']);
    Route::delete('/training-requests/{trainingRequest}', [TrainingRequestController::class, 'destroy']);

    // Approval
    Route::post('/training-requests/{trainingRequest}/approve-hrd', [TrainingRequestController::class, 'approveHrd']);
    Route::post('/training-requests/{trainingRequest}/reject-hrd', [TrainingRequestController::class, 'rejectHrd']);

    Route::post('/training-requests/{trainingRequest}/approve-director', [TrainingRequestController::class, 'approveDirector']);
    Route::post('/training-requests/{trainingRequest}/reject-director', [TrainingRequestController::class, 'rejectDirector']);

    
});